# ==============================================================================
# BUECHEREI 2.0 - POWERSHELL START-SKRIPT
# Prüft Konfiguration und startet die Hauptanwendung.
# ==============================================================================

Write-Host "=========================================================="
Write-Host "BUECHEREI 2.0 - START-SKRIPT"
Write-Host "=========================================================="
Write-Host ""

$ConfigFile = "config.json"
$UserFile = "users.json"
$SetupExe = "setup.exe"
$MainExe = "all.exe"

# --- 1. Konfigurationsdateien prüfen ---
Write-Host "[1] Prüfe Konfiguration..."

if (-not (Test-Path $ConfigFile) -or -not (Test-Path $UserFile)) {
    Write-Host ""
    Write-Host "[!] Kritische Konfigurationsdateien ($ConfigFile oder $UserFile) fehlen." -ForegroundColor Yellow
    Write-Host "[!] Starte Setup-Routine..." -ForegroundColor Yellow

    # Prüfen, ob die Setup-EXE existiert
    if (-not (Test-Path $SetupExe)) {
        Write-Host ""
        Write-Host "[X] FATALER FEHLER: $SetupExe nicht gefunden! Programmabbruch." -ForegroundColor Red
        Read-Host "Drücken Sie eine Taste zum Beenden..."
        exit 1
    }

    # Setup starten und auf Beendigung warten
    & "$SetupExe"
    
    # Erneute Prüfung nach Setup
    if (-not (Test-Path $ConfigFile) -or -not (Test-Path $UserFile)) {
        Write-Host ""
        Write-Host "[X] FATALER FEHLER: Setup wurde ausgeführt, aber Konfigurationsdateien fehlen weiterhin! Programmabbruch." -ForegroundColor Red
        Read-Host "Drücken Sie eine Taste zum Beenden..."
        exit 1
    }
    
    Write-Host ""
    Write-Host "[+] Setup erfolgreich abgeschlossen." -ForegroundColor Green
}

# --- 2. Hauptanwendung starten ---
Write-Host ""
Write-Host "[2] Starte Hauptanwendung $MainExe..."

# Startet die Haupt-EXE im Hintergrund
Start-Process -FilePath $MainExe

Write-Host ""
Write-Host "[+] Anwendung gestartet." -ForegroundColor Green

# Skript beenden, damit das Fenster nicht sofort verschwindet, wenn es manuell gestartet wird.
# Remove the line below if you want the window to close immediately after starting the application.
# Read-Host "Drücken Sie Enter zum Beenden des Start-Skripts..."
